/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.IOException;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;

public abstract class CustomizationItemBase
extends AbstractGui {
    public String value;
    public String action;
    public int posX = 0;
    public int posY = 0;
    public String orientation = "top-left";
    public int width = -1;
    public int height = -1;
    public volatile boolean delayAppearance = false;
    public volatile boolean delayAppearanceEverytime = false;
    public volatile float delayAppearanceSec = 1.0f;
    public volatile boolean visible = true;
    public volatile boolean fadeIn = false;
    public volatile float fadeInSpeed = 1.0f;
    public volatile float opacity = 1.0f;
    protected String actionId;

    public CustomizationItemBase(PropertiesSection item) {
        String h;
        String w;
        String o;
        String das;
        String legacyDae;
        String dae;
        String legacyDa;
        String da;
        String fis;
        String fi;
        this.action = item.getEntryValue("action");
        this.actionId = item.getEntryValue("actionid");
        if (this.actionId == null) {
            this.actionId = MenuCustomization.generateRandomActionId();
        }
        if ((fi = item.getEntryValue("fadein")) != null && fi.equalsIgnoreCase("true")) {
            this.fadeIn = true;
        }
        if ((fis = item.getEntryValue("fadeinspeed")) != null && MathUtils.isFloat((String)fis)) {
            this.fadeInSpeed = Float.parseFloat(fis);
        }
        if ((da = item.getEntryValue("delayappearance")) != null && da.equalsIgnoreCase("true")) {
            this.delayAppearance = true;
        }
        if ((legacyDa = item.getEntryValue("hideforseconds")) != null) {
            this.delayAppearance = true;
        }
        if ((dae = item.getEntryValue("delayappearanceeverytime")) != null && dae.equalsIgnoreCase("true")) {
            this.delayAppearanceEverytime = true;
        }
        if ((legacyDae = item.getEntryValue("delayonlyfirsttime")) != null && legacyDae.equalsIgnoreCase("false")) {
            this.delayAppearanceEverytime = true;
        }
        if ((das = item.getEntryValue("delayappearanceseconds")) != null && MathUtils.isFloat((String)das)) {
            this.delayAppearanceSec = Float.parseFloat(das);
        }
        if (legacyDa != null && MathUtils.isFloat((String)legacyDa)) {
            this.delayAppearanceSec = Float.parseFloat(legacyDa);
        }
        String x = item.getEntryValue("x");
        String y = item.getEntryValue("y");
        if (x != null && MathUtils.isInteger((String)(x = DynamicValueHelper.convertFromRaw(x)))) {
            this.posX = Integer.parseInt(x);
        }
        if (y != null && MathUtils.isInteger((String)(y = DynamicValueHelper.convertFromRaw(y)))) {
            this.posY = Integer.parseInt(y);
        }
        if ((o = item.getEntryValue("orientation")) != null) {
            this.orientation = o;
        }
        if ((w = item.getEntryValue("width")) != null) {
            if (MathUtils.isInteger((String)(w = DynamicValueHelper.convertFromRaw(w)))) {
                this.width = Integer.parseInt(w);
            }
            if (this.width < 0) {
                this.width = 0;
            }
        }
        if ((h = item.getEntryValue("height")) != null) {
            if (MathUtils.isInteger((String)(h = DynamicValueHelper.convertFromRaw(h)))) {
                this.height = Integer.parseInt(h);
            }
            if (this.height < 0) {
                this.height = 0;
            }
        }
    }

    public abstract void render(MatrixStack var1, Screen var2) throws IOException;

    public int getPosX(Screen menu) {
        int w = menu.field_230708_k_;
        int x = this.posX;
        if (this.orientation.equalsIgnoreCase("top-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            x += w / 2;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            x += w;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            x += w;
        }
        return x;
    }

    public int getPosY(Screen menu) {
        int h = menu.field_230709_l_;
        int y = this.posY;
        if (this.orientation.equalsIgnoreCase("mid-left")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-left")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            y += h;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            // empty if block
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            y += h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            y += h;
        }
        return y;
    }

    public boolean shouldRender() {
        if (this.value == null) {
            return false;
        }
        return this.visible;
    }

    public String getActionId() {
        return this.actionId;
    }

    protected static boolean isEditorActive() {
        return LayoutEditorScreen.isActive;
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }
    }
}

